/*
	File: CEG_smoke.sqf
	Version: 1.1
	Author: Loyalguard

	Description:
	A script to emit smoke from the power plant smokestacks.

	Parameters:
	_this select 0: The CEG object co-located with game logic that emits smoke (string).
	
	Execution:
	Executed from CEG_common.sqf on all machines except MP dedicated servers (since there is no one there to see the smoke).  Multiple instances of this script will be running concurrently, one for every logic that might emit smoke in the simulation.  If effects are stopped, this script can also be executed by CEG_events.sqf if/when effects are restarted.
*/

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_smoke.sqf: Thread started for:", (_this select 0)] call LGD_fnc_debugMessage;}; //DEBUG 

// Scope //
private ["_obj", "_bool", "_logic", "_source"];

// Parameter(s) //
_obj = (_this select 0);

// Assign local variables to store necessary information for the script to function.
_onStr = (format ["CEG_on_%1", _obj]);
_logicStr = (format ["CEG_logic_%1", _obj]);
_logic = missionNameSpace getVariable _logicStr; // The primary logic assigned to this object.

// Wait until "power" in on for this smokestack.
waitUntil {(missionNameSpace getVariable _onStr)};

// Emit smoke particles from the smokestack.
_smoke = "#particlesource" createVehicleLocal getPos _logic;
_smoke setParticleCircle [0, [0, 0, 0]];
_smoke setParticleRandom [0, [0.25, 0.25, 0], [0.175, 0.175, 0], 0, 0.25, [0, 0, 0, 0.1], 0, 0];
_smoke setParticleParams [["\Ca\Data\Cl_basic.p3d", 1, 0, 1], "", "Billboard", 1, 12.5, [0, 0, 0], [0, 0, 0.75], 0, 10, 7.9, 0.075, [1.2, 2, 4], [[0.1, 0.1, 0.1, 1], [0.25, 0.25, 0.25, 0.5], [0.5, 0.5, 0.5, 0]], [0.08], 1, 0, "", "", _logic];
_smoke setDropInterval 0.05;

// Emit smoke as long as "power" stays on.  When off, stop the smoke.
waitUntil {!(missionNameSpace getVariable _onStr)};
deleteVehicle _smoke;